taskID <- as.integer(Sys.getenv("SLURM_ARRAY_TASK_ID"))
library(sspse)

Np = c(5,10, 15)
N = c(1000,5000,10000)

sim_grid <- expand.grid(Np, N)

pop_params <- sim_grid[as.integer(taskID/100)+1,]

true_N <- as.numeric(pop_params[2])
true_Np <- as.numeric(pop_params[1])
print(true_N)

rds_results <- readRDS(paste0('rds_', taskID, '.rds'))
rds <- rds_results$rds

degrees <- rds$degrees[rds$recruited]

K = max(degrees)*2

results_matrix <- matrix(nrow = 4, ncol = 8)

k <- 1

for (i in c(3,4,5,8)){
  
  maxN = i*true_N
  
  #run the posteriorsize function from the SSPSE package
  posterior <- posteriorsize(s = degrees, K=K, 
                             priorsizedistribution = "flat",
                             visibility = F, maxN = maxN)
  
  print(posterior$N)
  
  results_matrix[k,] <- c(as.numeric(posterior$N), maxN, true_N, true_Np)
  
  k <- k+1
  
}

saveRDS( results_matrix, paste0("SS_results_",  taskID, '.rds'))
